extends CharacterBody3D

@onready var gunRay = $Camera3d/RayCast3d as RayCast3D
@onready var Cam = $Camera3d as Camera3D
@export var _bullet_scene : PackedScene

var mouseSensibility = 1200
var mouse_relative_x = 0
var mouse_relative_y = 0
var mouse_captured = false

var flyMode:bool = 0
var flyJump:bool = 0

const speedNormal = 5.0
const speedFast = 10.0
const jumpVelocity = 5
const jumpHight = 10
const maxSpeed = 50

# Get the gravity from the project settings to be synced with RigidBody nodes.
var gravity = ProjectSettings.get_setting("physics/3d/default_gravity")

func _ready():
	#Captures mouse and stops rgun from hitting yourself
	if mouse_captured:
		gunRay.add_exception(self)
		Input.mouse_mode = Input.MOUSE_MODE_CAPTURED
	else:
		Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
	
func _physics_process(delta):
	var input_dir
	var direction
	
	var SPEED = speedNormal
	var JUMP = jumpVelocity
	
	if Input.is_action_pressed("inputKEY_SHIFT"):
		SPEED = speedFast
		
	if flyMode or is_on_floor():
		velocity.y = 0
	else:
		velocity.y -= gravity * delta
	
	if mouse_captured or Input.is_action_pressed("inputMouseMiddle"):
		input_dir = Input.get_vector("inputLeft", "inputRight", "inputUp", "inputDown")

		if Input.is_action_pressed("inputTopLeft"):
			velocity.y = -SPEED

		if Input.is_action_pressed("inputTopRight"):
			velocity.y = SPEED

	else:
		input_dir = Input.get_vector("inputLowerRightCenter", "inputLowerRightEdge", "inputUp", "inputDown")
		if Input.is_action_pressed("inputLeft"): 
			rotate_y(0.05)
			
		if Input.is_action_pressed("inputRight"): 
			rotate_y(-0.05)
		
		if Input.is_action_pressed("inputTopRight")  and rad_to_deg($Head.rotation.x) > -100: 
			rotate_object_local(Vector3(1,0,0),0.05)
			$Head.rotate_object_local(Vector3(1,0,0),-0.05)
		
		if Input.is_action_pressed("inputTopLeft") and rad_to_deg($Head.rotation.x) < 100 : 
			rotate_object_local(Vector3(1,0,0),-0.05)
			$Head.rotate_object_local(Vector3(1,0,0),0.05)
			
		if Input.is_action_pressed("inputLowerLeftEdge"):
			velocity.y = -SPEED

		if Input.is_action_pressed("inputLowerLeftCenter"):
			velocity.y = SPEED

	if flyMode:
		JUMP = jumpHight
		direction = (transform.basis * Vector3(input_dir.x, 0, input_dir.y)).normalized()
		velocity.x = direction.x * SPEED
		velocity.y += direction.y * SPEED
		velocity.z = direction.z * SPEED
	else:
		velocity.x = (get_global_transform().basis.x.x * input_dir.x * SPEED)-(get_global_transform().basis.x.z * input_dir.y * SPEED)
		velocity.z = (get_global_transform().basis.x.z * input_dir.x * SPEED)+(get_global_transform().basis.x.x * input_dir.y * SPEED)

	if  Input.is_action_just_pressed("inputJump"):
		if flyMode or flyJump or is_on_floor():
			velocity.y += JUMP
				
	move_and_slide()

func _input(event):
	# Handle Shooting
	if Input.is_action_just_pressed("inputShoot"):
		shoot()	
	
	if Input.is_action_just_pressed("inputQuit"):
		get_tree().quit()
		
#	# Scene reset
#	if Input.is_action_just_pressed("inputSceneReset"):
#		get_tree().reload_current_scene()
#
#	if Input.is_action_pressed("g"): 
#		print(":",get_rotation_degrees(),":",get_rotation())
		
	if Input.is_action_pressed("inputFly"):
		if Input.is_action_pressed("inputKEY_SHIFT"):
			if flyJump:
				flyJump = 0
				print("FLY JUMP OFF")
			else:
				flyJump = 1
				print("FLY JUMP ON")
		else:
			if flyMode:
				flyMode = 0
				print("FLY MODE OFF")
			else:
				flyMode = 1
				print("FLY MODE ON")

	#TOGLE MOUSE MODE
	if Input.is_action_just_pressed("inputTogleMouseCapture"):  # Toggle mouse captured
		if mouse_captured:
			Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
			mouse_captured = false
		else:
			Input.set_mouse_mode(Input.MOUSE_MODE_CAPTURED)
			mouse_captured = true	

	if !mouse_captured:
		if Input.is_action_just_pressed("inputMouseMiddle"):
			Input.set_mouse_mode(Input.MOUSE_MODE_CAPTURED)
		if Input.is_action_just_released("inputMouseMiddle"):
			Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
			
	if event is InputEventMouseMotion and Input.get_mouse_mode() == Input.MOUSE_MODE_CAPTURED:
		rotation.y -= event.relative.x / mouseSensibility
		if (event.relative.y>0 and rad_to_deg($Head.rotation.x)<100 ) or (event.relative.y<0 and rad_to_deg($Head.rotation.x)>-100 ):
			rotate_object_local(Vector3(1,0,0), -event.relative.y / mouseSensibility)
			$Head.rotation.x += event.relative.y / mouseSensibility
			
		mouse_relative_x = clamp(event.relative.x, -50, 50)
		mouse_relative_y = clamp(event.relative.y, -50, 10)

func shoot():
	if not gunRay.is_colliding():
		return
	var bulletInst = _bullet_scene.instantiate() as Node3D
	bulletInst.set_as_top_level(true)
	get_parent().add_child(bulletInst)
	bulletInst.global_transform.origin = gunRay.get_collision_point() as Vector3
	bulletInst.look_at((gunRay.get_collision_point()+gunRay.get_collision_normal()),Vector3.BACK)
	print(gunRay.get_collision_point())
	print(gunRay.get_collision_point()+gunRay.get_collision_normal())
